clear

figure('Position', [200 80 1000 600])

t = tiledlayout(3,5);
t.TileSpacing = 'none';
t.Padding = 'none';
title(t, 'Crank Phasing [deg]', 'FontWeight', 'Bold', 'FontSize', 12)
ylabel(t, {'';'';'';''}, 'FontWeight', 'Bold', 'FontSize', 12)

phi = 0:5:20;
ExPortH = 0.075:0.0125:0.225;
InPortH = 0.05:0.0125:0.2;

a = 41.6625;
l = 166.65;
B = 75.75;
theta = -180:0.01:180;

IPO = zeros(length(InPortH),length(ExPortH),length(phi));
IPC = zeros(length(InPortH),length(ExPortH),length(phi));
EPO = zeros(length(InPortH),length(ExPortH),length(phi));
EPC = zeros(length(InPortH),length(ExPortH),length(phi));
FPO = zeros(length(InPortH),length(ExPortH),length(phi));
LPO = zeros(length(InPortH),length(ExPortH),length(phi));
FPC = zeros(length(InPortH),length(ExPortH),length(phi));
LPC = zeros(length(InPortH),length(ExPortH),length(phi));

BlowdownDuration = zeros(length(InPortH),length(ExPortH),length(phi));
ScavengingDuration = zeros(length(InPortH),length(ExPortH),length(phi));
IntakeDuration = zeros(length(InPortH),length(ExPortH),length(phi));

for k = 1:length(phi)
    
    IntakePistonPosition = (a - l + a*cos((theta-(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta-(phi(k)/2))*pi/180).^2))/(2*a);
    ExhaustPistonPosition = (a - l + a*cos((theta+(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta+(phi(k)/2))*pi/180).^2))/(2*a);

    
    for j = 1:length(ExPortH)
        for i = 1:length(InPortH)
            
            IPO(i,j,k) = theta(find(IntakePistonPosition>InPortH(i),1, 'last'));
            IPC(i,j,k) = theta(find(IntakePistonPosition>InPortH(i),1));
            
            EPO(i,j,k) = theta(find(ExhaustPistonPosition>ExPortH(j),1, 'last'));
            EPC(i,j,k) = theta(find(ExhaustPistonPosition>ExPortH(j),1));

            FPO(i,j,k) = min(IPO(i,j,k),EPO(i,j,k));
            LPO(i,j,k) = max(IPO(i,j,k),EPO(i,j,k));
            
            FPC(i,j,k) = min(IPC(i,j,k),EPC(i,j,k));
            LPC(i,j,k) = max(IPC(i,j,k),EPC(i,j,k));
            
            BlowdownDuration(i,j,k) = IPO(i,j,k) - EPO(i,j,k);
            ScavengingDuration(i,j,k) = 360 + FPC(i,j,k) - LPO(i,j,k);
            IntakeDuration(i,j,k) = IPC(i,j,k) - EPC(i,j,k);
            
        end
    end
    
   
    c = flipud(jet(1000));

    nexttile(k)
    contourf(ExPortH,InPortH,BlowdownDuration(:,:,k),(-100:10:300), 'ShowText', 'on', 'LineColor', [0.2 0.2 0.2]);
    colormap(gca, c(250:750,:))
    caxis([-30 120])
    str = num2str(phi(k));
    title({str;''}, 'FontWeight', 'bold', 'FontSize', 12)
    set(gca,'Xticklabel',[])
    set(gca, 'FontSize', 10)
    
    if k == 1
        yticks(0:0.05:0.3)
        ytickformat('%.2f')
    else
        set(gca,'Yticklabel',[])
    end
    
    axis('square')
    
    nexttile(length(phi) + k)
    contourf(ExPortH,InPortH,ScavengingDuration(:,:,k),(-100:10:300), 'ShowText', 'on');
    colormap(gca, c(250:750,:))
    caxis([-30 120])
    set(gca,'Xticklabel',[])
    set(gca, 'FontSize', 10)
    
    if k == 1
        yticks(0:0.05:0.3)
        ytickformat('%.2f')
        ylabel('Intake Port Height Ratio', 'FontSize', 10)
    else
        set(gca,'Yticklabel',[])
    end
    
    axis('square')

  
    nexttile(2*length(phi) + k)
    contourf(ExPortH,InPortH,IntakeDuration(:,:,k),(-100:10:300), 'ShowText', 'on');
    colormap(gca, c(250:750,:))
    caxis([-30 120])
    xticks(0:0.05:0.3)
    xtickformat('%.2f')
    set(gca, 'FontSize', 10)
    
    if k == 1
        yticks(0:0.05:0.3)
        ytickformat('%.2f')
    elseif k == 3
        set(gca,'Yticklabel',[])
        xlabel('Exhaust Port Height Ratio', 'FontSize', 10)
    else
        set(gca,'Yticklabel',[])
    end

    axis('square')

   
end

cb = colorbar;
cb.Layout.Tile = 'east';
cb.Ticks = -30:30:120;
cb.FontSize = 10;
cb.Title.FontSize = 12;
cb.Title.String = ['CA' char(176)];

annotation('textbox', [0.00, 0.80, 0, 0], 'string', 'Blowdown Duration', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.00, 0.52, 0, 0], 'string', 'Scavenge Duration', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.00, 0.24, 0, 0], 'string', 'Intake Duration', 'FontWeight', 'bold', 'FontSize', 12)
